-- new script file

function OnAfterSceneLoaded(self)
  self:AddTriggerTarget("groupCreated")
  self:AddTriggerTarget("targetCompleted")
  self:AddTriggerSource("groupRetreat")
end

function OnThink(self)
  if not self.initialized then
    self.initialized = true
    
    self.gC = -1 -- groups counter
    self.tC = 0 -- targets counter
    self.p1 = Citadels.GetPlayer(1)
    
    self.groupReady = false
    self.targetDone = false
    self.targets = {}
    self.groups = {}
    
    self.groupRetreat:LinkToTarget("handleRetreat")
    SetupNodes(self)
  end
  
  if self.groupReady then
    if self.gC > 0 then
      self.groupRetreat:TriggerAllTargets()  
    end
    SendWave(self)
    self.groupReady = false
  end
 
  if self.targetDone then
    self.tC = self.tC + 1
    if self.tc > 3 then
      self.targetDone = false
      return
    end
    SendWave(self)
    self.targetDone = false
  end
end

function SendWave(self)
  self.p1:Deselect()
  self.p1:SelectUnitsByName(self.groups[self.gC]..'*')
  self.p1:SetAggressive()
  self.p1:Move(self.targets[self.tC])
end

function OnTrigger(self, source, target)
  if target == "groupCreated" then
		if source == "toAttReady" then
			self.gC = 0
		elseif source == "stAttReady" then
			self.gC = 1
		elseif source == "mdAttReady" then
			self.gC = 2
		end    
		self.tC = 0
    self.groupReady = true
  elseif target == "targetCompleted" then
    self.targetDone = true
  end
end

function SetupNodes(self)
  self.targets[0] = Game:GetEntity("hillMonastery"):GetPosition()
  self.targets[1] = Game:GetEntity("castleBottom"):GetPosition()
  self.targets[2] = Game:GetEntity("castleSquare"):GetPosition()
  self.targets[3] = Game:GetEntity("castleMain"):GetPosition()
  
  self.groups[0] = "toAtt_"
  self.groups[1] = "stAtt_"
  self.groups[2] = "mdAtt_"
end
